/*
 * Decompiled with CFR 0.152.
 */
package org.pokesplash.gts.history;

import com.cobblemon.mod.common.pokemon.Pokemon;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.minecraft.class_1799;
import org.pokesplash.gts.Gts;
import org.pokesplash.gts.Listing.Listing;
import org.pokesplash.gts.api.provider.HistoryAPI;
import org.pokesplash.gts.history.HistoryItem;
import org.pokesplash.gts.history.ItemHistoryItem;
import org.pokesplash.gts.history.PlayerHistory;
import org.pokesplash.gts.history.PokemonHistoryItem;
import org.pokesplash.gts.oldVersion.PlayerHistoryOld;
import org.pokesplash.gts.util.Deserializer;
import org.pokesplash.gts.util.Utils;

public class HistoryProvider {
    public static final String filePath = "/config/gts/history/";
    private static final String brokeFilesPath = "/config/gts/invalid/history/";
    protected HashMap<UUID, PlayerHistory> history = new HashMap();

    public HashMap<UUID, PlayerHistory> getHistory() {
        return this.history;
    }

    protected void putHistory(UUID uuid, PlayerHistory playerHistory) {
        this.history.put(uuid, playerHistory);
    }

    protected void removeHistory(UUID uuid) {
        this.history.remove(uuid);
    }

    public PlayerHistory getPlayerHistory(UUID player) {
        if (this.getHistory().get(player) == null) {
            if (HistoryAPI.getHighestPriority() == null) {
                new PlayerHistory(player);
            } else {
                this.putHistory(player, new PlayerHistory(player));
            }
        }
        return this.getHistory().get(player);
    }

    public HistoryItem findHistoryById(UUID id) {
        for (PlayerHistory h : this.getHistory().values()) {
            for (HistoryItem item : h.getListings()) {
                if (!item.getId().equals(id)) continue;
                return item;
            }
        }
        return null;
    }

    public void updateHistory(PlayerHistory history) {
        this.putHistory(history.getPlayer(), history);
    }

    public void addHistoryItem(Listing item, String buyerName) {
        if (this.getHistory().get(item.getSellerUuid()) == null) {
            this.putHistory(item.getSellerUuid(), new PlayerHistory(item.getSellerUuid()));
        }
        PlayerHistory playerHistory = this.getHistory().get(item.getSellerUuid());
        playerHistory.addListing(item, buyerName);
        this.putHistory(item.getSellerUuid(), playerHistory);
    }

    public double getAveragePrice(class_1799 itemStack) {
        double total = 0.0;
        int amount = 0;
        for (PlayerHistory h : this.getHistory().values()) {
            for (ItemHistoryItem item : h.getItemListings()) {
                if (!class_1799.method_7984((class_1799)item.getListing(), (class_1799)itemStack)) continue;
                total += item.getPrice();
                ++amount;
            }
        }
        if (total == 0.0) {
            return 0.0;
        }
        BigDecimal bd = BigDecimal.valueOf(total / (double)amount);
        return bd.setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public double getAveragePrice(Pokemon pokemon) {
        double total = 0.0;
        int amount = 0;
        for (PlayerHistory h : this.getHistory().values()) {
            for (PokemonHistoryItem mon : h.getPokemonListings()) {
                if (mon.getListing().getSpecies().getNationalPokedexNumber() != pokemon.getSpecies().getNationalPokedexNumber()) continue;
                total += mon.getPrice();
                ++amount;
            }
        }
        if (total == 0.0) {
            return 0.0;
        }
        BigDecimal bd = BigDecimal.valueOf(total / (double)amount);
        return bd.setScale(2, RoundingMode.HALF_UP).doubleValue();
    }

    public void init() {
        File[] files;
        File dir = Utils.checkForDirectory(filePath);
        for (File file : files = dir.listFiles()) {
            if (file.isFile()) {
                Utils.readFileAsync(filePath, file.getName(), el -> {
                    Gson gson = new Gson();
                    try {
                        PlayerHistoryOld oldPlayer = (PlayerHistoryOld)gson.fromJson(el, PlayerHistoryOld.class);
                        PlayerHistory newPlayer = new PlayerHistory(oldPlayer);
                        Utils.deleteFile(filePath, file.getName());
                        this.putHistory(newPlayer.getPlayer(), newPlayer);
                    }
                    catch (Exception e) {
                        Gts.LOGGER.error("Could not convert file " + file.getName() + " to a GTS Player History");
                        e.printStackTrace();
                    }
                });
                continue;
            }
            File[] playerFiles = file.listFiles();
            ArrayList<HistoryItem> items = new ArrayList<HistoryItem>();
            UUID playerId = UUID.fromString(file.getName());
            for (File playerFile : playerFiles) {
                if (!playerFile.isFile()) continue;
                Utils.readFileAsync(filePath + file.getName() + "/", playerFile.getName(), el -> {
                    GsonBuilder builder = new GsonBuilder();
                    builder.registerTypeAdapter(HistoryItem.class, (Object)new Deserializer(PokemonHistoryItem.class));
                    builder.registerTypeAdapter(HistoryItem.class, (Object)new Deserializer(ItemHistoryItem.class));
                    Gson gson = builder.setPrettyPrinting().create();
                    try {
                        HistoryItem item = (HistoryItem)gson.fromJson(el, HistoryItem.class);
                        HistoryItem historyItem = item = item.isPokemon() ? (HistoryItem)gson.fromJson(el, PokemonHistoryItem.class) : (HistoryItem)gson.fromJson(el, ItemHistoryItem.class);
                        if (!item.isHistoryItemValid()) {
                            System.out.println("[GTS] Invalid file: " + playerFile.getName() + " has been removed.");
                            Utils.writeFileAsync(brokeFilesPath, playerFile.getName(), gson.toJson((Object)item));
                            Utils.deleteFile(filePath + file.getName() + "/", playerFile.getName());
                            return;
                        }
                        if (!item.getVersion().equals("2.0")) {
                            // empty if block
                        }
                        items.add(item);
                    }
                    catch (Exception e) {
                        Gts.LOGGER.error("Could not read player GTS History file for " + file.getName());
                        e.printStackTrace();
                    }
                });
            }
            this.putHistory(playerId, new PlayerHistory(playerId, items));
        }
    }
}

